
// LiveResizeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LiveResize.h"
#include "LiveResizeDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

VOID LiveResize_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[LiveResize] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

BOOL on_process_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CLiveResizeDlg * pMainDialog = (CLiveResizeDlg *)(pUserData);

	pMainDialog->m_pYUVFrameBuffer = pBuffer;	

	RESIZE_MMX( PREVIEW_COLORSPACE, WIDTH, HEIGHT, 0, REWIDTH, REHEIGHT, 0, pMainDialog->m_pResizeYUVFrameBuffer, pBuffer );

	return TRUE;
}

// CLiveResizeDlg dialog

CLiveResizeDlg::CLiveResizeDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CLiveResizeDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev = 0xFFFFFFFF;

	m_hDrawDib = NULL;

	m_pYUVFrameBuffer = NULL;

	m_pResizeYUVFrameBuffer = NULL;

	m_pRGBFrameBuffer = NULL;
}

void CLiveResizeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);	
}

BEGIN_MESSAGE_MAP(CLiveResizeDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_TIMER()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// CLiveResizeDlg message handlers

BOOL CLiveResizeDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_pRGBFrameBuffer = (BYTE *)(malloc( WIDTH * HEIGHT * 4 ));

	ZeroMemory( m_pRGBFrameBuffer, WIDTH * HEIGHT * 4 );

	m_pResizeYUVFrameBuffer = (BYTE *)(malloc( REWIDTH * REHEIGHT * 2 ));
	
	ZeroMemory( m_pResizeYUVFrameBuffer, REWIDTH * REHEIGHT * 2 );

	m_hDrawDib = DrawDibOpen();

	// INITIALIZE BITMAP INFO HEADER
	//
	m_video_bitmap_info_header.biSize					= sizeof(BITMAPINFOHEADER);
	m_video_bitmap_info_header.biWidth				= REWIDTH;
	m_video_bitmap_info_header.biHeight				= REHEIGHT;
	m_video_bitmap_info_header.biPlanes				= 1;
	m_video_bitmap_info_header.biBitCount			= 32;
	m_video_bitmap_info_header.biCompression    = BI_RGB;
	m_video_bitmap_info_header.biSizeImage			= (REWIDTH * REHEIGHT * 4);
	m_video_bitmap_info_header.biXPelsPerMeter  = 0;
	m_video_bitmap_info_header.biYPelsPerMeter  = 0;
	m_video_bitmap_info_header.biClrUsed			= 0;
	m_video_bitmap_info_header.biClrImportant		= 0;

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );	

	m_hVideoDev = AMESDK_CREATE( AMESDK_PRODUCT, 0, 0, NULL, on_process_video_buffer, this );		

	AMESDK_SET_STANDARD( m_hVideoDev, NTSC );

	AMESDK_SET_FORMAT( m_hVideoDev, PREVIEW_COLORSPACE, WIDTH, HEIGHT, BIT_COUNT, FPS ); // RESOLUTION = 1920  1088  29.97 / NTSC	

	AMESDK_SET_INPUT( m_hVideoDev, SDI_INPUT );

	AMESDK_RUN( m_hVideoDev );

	SetTimer( 0x00000001, 33, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLiveResizeDlg::OnDestroy() 
{
	CDialogEx::OnDestroy();
	
	// TODO: Add your message handler code here

	KillTimer( 0x00000001 );
		
	// UNINITIALIZE DEVICE RESOURCE
	//
	if( m_hVideoDev != 0xFFFFFFFF )  {  AMESDK_DESTROY( m_hVideoDev ); m_hVideoDev = 0xFFFFFFFF;  }	

	if ( m_pRGBFrameBuffer )
	{
		free( m_pRGBFrameBuffer );

		m_pRGBFrameBuffer = NULL;
	}

	if ( m_pResizeYUVFrameBuffer )
	{
		free( m_pResizeYUVFrameBuffer );

		m_pResizeYUVFrameBuffer = NULL;
	}

	if ( m_hDrawDib )
	{
		DrawDibClose( m_hDrawDib );

		m_hDrawDib = NULL;
	}

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();	
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLiveResizeDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
	
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLiveResizeDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CLiveResizeDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000001 )
	{	
		if ( m_pYUVFrameBuffer != NULL )
		{	
			COLORSPACE_YV12_TO_RGB32_MMX( REWIDTH, REHEIGHT, 0,  REWIDTH, REHEIGHT, 0, m_pRGBFrameBuffer, m_pResizeYUVFrameBuffer, 0x00, FALSE, TRUE );
			
			CDC *pDC = GetDC();

			HDC hDC = pDC->GetSafeHdc();

			CBrush  brush(RGB(255, 255, 255));

			CRect rt; GetClientRect(&rt);

			HBITMAP hBackBitmap = CreateCompatibleBitmap(hDC, rt.right - rt.left, rt.bottom - rt.top);

			HDC hBitmapDC = ::CreateCompatibleDC(hDC);

			HBITMAP hOldBitmap = (HBITMAP)SelectObject(hBitmapDC, hBackBitmap);

			::FillRect(hBitmapDC, &rt, brush);			

			BOOL bDraw = DrawDibDraw(m_hDrawDib, hBitmapDC, rt.left, rt.top, rt.right, rt.bottom, (LPBITMAPINFOHEADER) &m_video_bitmap_info_header, (LPVOID) m_pRGBFrameBuffer, 0, 0, REWIDTH, REHEIGHT, DDF_BACKGROUNDPAL );		

			BitBlt(hDC, rt.left, rt.top, rt.Width(), rt.Height(), hBitmapDC, 0, 0, SRCCOPY);

			SelectObject(hBitmapDC, hOldBitmap);

			DeleteDC(hBitmapDC);

			DeleteObject(hBackBitmap);

			ReleaseDC(pDC);
		}	
	}

	CDialogEx::OnTimer(nIDEvent);
}

BOOL CLiveResizeDlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
		
	return CDialog::OnEraseBkgnd(pDC);
}

void CLiveResizeDlg::OnSize(UINT nType, int cx, int cy) 
{	
	// FOR WINDOW RESIZE
	//

	CWnd::OnSize(nType, cx, cy);	
}